<?php

require_once '../model/database.php';
require_once '../model/vendor_model.php';
require_once '../model/product_model.php';
require_once 'header.php';

if (isset($_GET['id'])) {
    $vend_id = $_GET['id'];
    $products = get_products_by_vendor($conn, $vend_id);
    $vendor = get_vendor_by_id($conn, $vend_id);

    if ($vendor) {
        echo "<h1>Products from Vendor: " . $vendor['vend_name'] . "</h1>";
        echo "<nav><a href='../index.php'>Home</a> | <a href='manage_vendors.php'>Manage Vendors</a> | <a href='product_info.php'>Product Info</a></nav>";

        if (!empty($products)) {
            echo "<table>";
            echo "<table border='1' cellpadding='5'>";
            echo "<tr><th>Product ID</th><th>Product Name</th><th>Product Price</th><th>Product Description</th></tr>";
            foreach ($products as $product) {
                echo "<tr>";
                echo "<td>" . $product['prod_id'] . "</td>";
                echo "<td>" . $product['prod_name'] . "</td>";
                echo "<td>" . $product['prod_price'] . "</td>";
                echo "<td>" . $product['prod_desc'] . "</td>";
                echo "</tr>";
            }
            echo "</table>";
        } else {
            echo "<p>No products found from this vendor.</p>";
        }
    } else {
        echo "<p>Vendor not found.</p>";
    }
} else {
    echo "<p>Vendor ID not provided.</p>";
}

require_once 'footer.php';
?>
